/*

  Zapocet do P009 - OpenGL priklad
  (c) 2000, Ales Berka (xberka1@fi.muni.cz)


*/

#include <stdio.h>
#include <math.h>
#include <windows.h>
#include "glut.h"

GLuint	wnd;
int		MainWidth = 640, MainHeight = 480;
float	uhel = 0.0;
float	stav = -100.0;
GLfloat tx = 0.0, ty = 0.0, tz = 0.0;
bool	follow = 0;
	

/* -----------------------------------------------------------------------------------------
   Prototypy
   ----------------------------------------------------------------------------------------- */

void createScene(void);
void setProjection(void);

/* -----------------------------------------------------------------------------------------
   Callbacky okna
   ----------------------------------------------------------------------------------------- */

void ReshapeFunc(int width, int height) 
{
	// Zmena velikosti okna
    glViewport(0, 0, width, height);
    setProjection();
}

void DisplayFunc(void)
{
	// Vykresleni okna
	glClearColor(0.0, 0.0, 0.0, 0.0);
    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

	createScene(); 

    glutPostRedisplay(); // Zajistuje opakovane volani teto metody
    glutSwapBuffers(); 
}


void KeyboardFunc(unsigned char key, int x, int y)
{
	// Stisk klavesy
    switch (key) {
        case 27: // Escape
			exit(0);
			break;
    }
}

void MenuFunc(int value)
{
	switch (value)
	{
	case 'a': 
		follow = !follow; 
		if (follow)
			MessageBox(0, "Sledovn konviky divok, neposedn...", "Hon na konviku", 0); else
			MessageBox(0, "U se mi to hlava. Dost pronsledovn...", "Hon na konviku", 0);
		setProjection();
		break;
	}
}

void MouseFunc(int button, int state, int x, int y)
{
	if (follow) return;
	if (button = GLUT_MIDDLE_BUTTON)
	{
		glMatrixMode(GL_PROJECTION);
		glLoadIdentity();

		gluPerspective(40,-1,0,10);
		gluLookAt(0, 20, -10,					// Umisteni kamery
				  (-x/35)+10, (-y/35)+10, 0,	// Cil kamery
				  0,0,1);						// Horizont zaberu
	}
}


/* -----------------------------------------------------------------------------------------
   Vlastni metody
   ----------------------------------------------------------------------------------------- */

void setProjection(void)
{
	// Nastaveni pohledu
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();

	// Perspektivni zobrazeni:
	gluPerspective(40,-1,0,10);
	if (!follow)
	{
		gluLookAt(0,30,-10,		// Umisteni kamery
				  0,0,0,		// Cil kamery
				  0,0,1);		// Horizont zaberu
	} else
	{
		gluLookAt(0,30,-10,		// Umisteni kamery
				  tx,ty,tz,		// Cil kamery
				  0,0,1);		// Horizont zaberu
	}
}

 
void createScene(void)
{
	glMatrixMode(GL_MODELVIEW);

	// Podlozka (duhova)
    glLoadIdentity();
    glBegin(GL_POLYGON);
		glColor3f(1,0,0);	glVertex3f(-10,0,-10);
		glColor3f(0,1,0);	glVertex3f(10,0,-10);
		glColor3f(0,0,1);	glVertex3f(10,0,10);
		glColor3f(0,1,1);	glVertex3f(-10,0,10);
	glEnd();

	// Trojuhelnik - trasa konvicky
	glColor3f(0.0f, 0.8f, 0.7f); 
	glBegin(GL_LINE_LOOP);
		glVertex3f(0.0, 0.0, 5.0);
		glVertex3f(-5.0, 0.0, -5.0);
		glVertex3f(5.0, 0.0, -5.0);
	glEnd();
	
	// Dratovy model koule
	glLoadIdentity();
	glColor3f(1.0f, 1.0f, 0.6f);
	glTranslatef(5.0, 0.0, 1.0);
	glutWireSphere(1.5, 15.0, 15.0);
	
	// Krychle
	glLoadIdentity();
	glColor3f(0.6f, 1.0f, 1.0f);
	glTranslatef(-5.0, 0.0, 4.0);
	glMateriali(GL_FRONT, GL_SHININESS, 0);
	glutSolidCube(2.0);

	// Konvicka
	glColor3f(1.0f, 0.2f, 0.3f);

	// Animace konvicky
	if (stav == 0.0)
	{	// Pravy dolni roh, divoka otocka
		glLoadIdentity();
		if (uhel < 120+3*360) 
		{
			tx = 5.0;
			ty = 0.0;
			tz = -5.0;
			glTranslatef(tx, ty, tz);
			uhel += (((3*360+120)/2 + 5) - abs((3*360+120)/2 - uhel)) / 5;
			
			glRotated(-uhel, 0, 1, 0);
		} else
		{
			stav += 0.1f;
			uhel = 120;

		}
	}
	if (stav > 0.0 && stav < 15.0)
	{ // 1. cesta
		float a = (5 * stav / 15);
		float b = (2 * a);
	
		glLoadIdentity();
		tx = 5 - a;
		ty = 0.0;
		tz = b - 5;
		glTranslatef(tx, ty, tz);
		glRotated(-120, 0, 1, 0);
		
		stav += (7.5 - abs(7.5 - stav)) / 10;

		// Osetreni nepresnosti floatu
		if (stav > 15.0) stav = 15.0;
	}
	if (stav == 15.0)
	{	// Horni roh, otocka o dalsich 120 stupnu
		glLoadIdentity();
		if (uhel < 240) 
		{
			tx = 0.0;
			ty = 0.0;
			tz = 5.0;
			glTranslatef(tx, ty, tz);
			//uhel += 5;
			uhel += (65 - abs(180 - uhel)) / 5;
			glRotated(-uhel, 0, 1, 0);
		} else
		{
			stav += 0.1f;
			uhel = 240;
		}
	}
	if (stav > 15.0 && stav < 30.0)
	{ // 2. cesta
		float a = (5 * (stav-15) / 15);
		float b = (2 * a);
	
		glLoadIdentity();
		tx = 0 - a;
		ty = 0.0;
		tz = 5 - b;
		glTranslatef(tx, ty, tz);
		glRotated(-240, 0, 1, 0);
		//stav += 0.5;
		stav += (7.5 - abs(22.5 - stav)) / 10;

		// Osetreni nepresnosti floatu
		if (stav > 30.0) stav = 30.0;
	}
	if (stav == 30.0)
	{	// Levy dolni roh, otocka o dalsich 120 stupnu
		glLoadIdentity();
		if (uhel < 360) 
		{
			tx = -5.0;
			ty = 0.0;
			tz = -5.0;
			glTranslatef(tx, ty, tz);
			//uhel += 5;
			uhel += (65 - abs(300 - uhel)) / 5;
			glRotated(-uhel, 0, 1, 0);
		} else
		{
			stav += 0.1f;
			uhel = 0;
		}
	}
	if (stav > 30.0 && stav < 45.0)
	{ // Posledni cesta
		float a = (5 * (stav-30) / 15);
		float b = (2 * a);
	
		glLoadIdentity();
		tx = -5 + b;
		ty = 0.0;
		tz = -5.0;
		glTranslatef(tx, ty, tz);
		//stav += 0.5;
		stav += (7.5 - abs(37.5 - stav)) / 10;

		// Osetreni nepresnosti floatu
		if (stav >= 45.0) stav = 0.0;
	}
	if (stav < 0.0) 
	{ // Zjeveni
		glLoadIdentity();
		tx = 5.0;
		ty = 0.0;
		tz = -5.0;
		glTranslatef(tx, ty, tz);
		
		stav += abs(10.0 - stav) / 10;
		float size = abs(-100 - stav);
		size = size / 100;

		uhel = size * (360 + 240);
		glRotated(uhel, 0, 1, 0);

		glutWireTeapot(2.0 * size);
		if (stav >= 0.0)
		{
			uhel = 120;
			stav = 0.1f;
		}
	} else glutWireTeapot(2.0);

	// Zamerit kameru
	if (follow) setProjection();
}


/* -----------------------------------------------------------------------------------------
   main
   ----------------------------------------------------------------------------------------- */

int main(int argc, char** argv)
{
	int border = GetSystemMetrics(SM_CXFRAME);

    glutInitDisplayMode(GLUT_RGB | GLUT_DEPTH | GLUT_DOUBLE); 
    glutInitWindowSize(MainWidth, MainHeight);
    glutInitWindowPosition(0, 0);
    glutInit(&argc, argv);

	// Hlavni okno
    wnd = glutCreateWindow("P009 - Zpoet, 2000 jaro, Ale Berka, xberka1@fi.muni.cz");
	glutReshapeFunc(ReshapeFunc);
    glutDisplayFunc(DisplayFunc);
    glutKeyboardFunc(KeyboardFunc);
	glutMouseFunc(MouseFunc);
     
	glutCreateMenu(MenuFunc);
    glutAddMenuEntry("Ne/pronsledovn konviky zken", 'a');
	glutAttachMenu(GLUT_RIGHT_BUTTON); 
                  
	setProjection();

    glutMainLoop();

    return 0;
}
